/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.cobalt.internal.doubles;

import cc.tweaked.cobalt.internal.doubles.Assert;
import cc.tweaked.cobalt.internal.doubles.DecimalRepBuf;
import cc.tweaked.cobalt.internal.doubles.DiyFp;
import cc.tweaked.cobalt.internal.doubles.Doubles;
import cc.tweaked.cobalt.internal.doubles.PowersOfTenCache;
import cc.tweaked.cobalt.internal.doubles.UnsignedValues;
import org.checkerframework.checker.signedness.qual.Unsigned;

final class FastDtoa {
    private static final int ASCII_ZERO = 48;
    public static final int FAST_DTOA_MAXIMAL_LENGTH = 17;
    private static final int MINIMAL_TARGET_EXPONENT = -60;
    private static final int MAXIMAL_TARGET_EXPONENT = -32;
    private static final @Unsigned int[] SMALL_POWERS_OF_TEN = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    FastDtoa() {
    }

    private static boolean roundWeedCounted(DecimalRepBuf buf, @Unsigned long rest, @Unsigned long tenKappa, @Unsigned long unit, int[] kappa) {
        assert (UnsignedValues.ulongLT(rest, tenKappa));
        if (UnsignedValues.ulongGE(unit, tenKappa)) {
            return false;
        }
        if (UnsignedValues.ulongLE(tenKappa - unit, unit)) {
            return false;
        }
        if (UnsignedValues.ulongGT(tenKappa - rest, rest) && UnsignedValues.ulongGE(tenKappa - 2L * rest, 2L * unit)) {
            return true;
        }
        if (UnsignedValues.ulongGT(rest, unit) && UnsignedValues.ulongLE(tenKappa - (rest - unit), rest - unit)) {
            kappa[0] = kappa[0] + buf.incrementLast();
            return true;
        }
        return false;
    }

    static void biggestPowerTen(@Unsigned int number, int numberBits, @Unsigned int[] power, int[] exponentPlusOne) {
        Assert.requireArg(UnsignedValues.uintLT(number, 1 << numberBits + 1), "number must fit in numberBits");
        int exponentPlusOneGuess = (numberBits + 1) * 1233 >> 12;
        int pow = SMALL_POWERS_OF_TEN[++exponentPlusOneGuess];
        if (UnsignedValues.uintLT(number, pow)) {
            pow = SMALL_POWERS_OF_TEN[--exponentPlusOneGuess];
        }
        power[0] = pow;
        exponentPlusOne[0] = exponentPlusOneGuess;
    }

    private static boolean digitGenCounted(DiyFp w, int requestedDigits, DecimalRepBuf buf, int[] kappa) {
        int divisorExponentPlusOne;
        assert (-60 <= w.exponent() && w.exponent() <= -32);
        long wError = 1L;
        DiyFp one = new DiyFp(1L << -w.exponent(), w.exponent());
        @Unsigned int integrals = UnsignedValues.toUint(w.significand() >>> -one.exponent());
        long fractionals = w.significand() & one.significand() - 1L;
        int[] inDivisorExponentPlusOne = new int[1];
        @Unsigned int[] inDivisor = new int[1];
        FastDtoa.biggestPowerTen(integrals, 64 - -one.exponent(), inDivisor, inDivisorExponentPlusOne);
        int divisor = inDivisor[0];
        kappa[0] = divisorExponentPlusOne = inDivisorExponentPlusOne[0];
        buf.clearBuf();
        while (kappa[0] > 0) {
            buf.append(UnsignedValues.uDivide(integrals, divisor));
            integrals = UnsignedValues.uRemainder(integrals, divisor);
            kappa[0] = kappa[0] - 1;
            if (--requestedDigits == 0) break;
            divisor = UnsignedValues.uDivide(divisor, 10);
        }
        if (requestedDigits == 0) {
            long rest = (UnsignedValues.toUlong(integrals) << -one.exponent()) + fractionals;
            return FastDtoa.roundWeedCounted(buf, rest, UnsignedValues.toUlong(divisor) << -one.exponent(), wError, kappa);
        }
        assert (one.exponent() >= -60);
        assert (UnsignedValues.ulongLT(fractionals, one.significand()));
        assert (UnsignedValues.ulongGE(UnsignedValues.uDivide(-1L, 10L), one.significand()));
        while (requestedDigits > 0 && UnsignedValues.ulongGT(fractionals, wError)) {
            wError *= 10L;
            buf.append((fractionals *= 10L) >>> -one.exponent());
            --requestedDigits;
            fractionals &= one.significand() - 1L;
            kappa[0] = kappa[0] - 1;
        }
        if (requestedDigits != 0) {
            return false;
        }
        return FastDtoa.roundWeedCounted(buf, fractionals, one.significand(), wError, kappa);
    }

    private static boolean grisu3Counted(double v, int requestedDigits, DecimalRepBuf buf, int[] decimalExponent) {
        DiyFp w = Doubles.asNormalizedDiyFp(v);
        DiyFp[] inTenMk = new DiyFp[1];
        int[] inMk = new int[1];
        int tenMkMinimalBinaryExponent = -60 - (w.exponent() + 64);
        int tenMkMaximalBinaryExponent = -32 - (w.exponent() + 64);
        PowersOfTenCache.getCachedPowerForBinaryExponentRange(tenMkMinimalBinaryExponent, tenMkMaximalBinaryExponent, inTenMk, inMk);
        DiyFp ten_mk = inTenMk[0];
        int mk = inMk[0];
        assert (-60 <= w.exponent() + ten_mk.exponent() + 64);
        assert (-32 >= w.exponent() + ten_mk.exponent() + 64);
        DiyFp scaledW = DiyFp.times(w, ten_mk);
        int[] inKappa = new int[1];
        boolean result = FastDtoa.digitGenCounted(scaledW, requestedDigits, buf, inKappa);
        decimalExponent[0] = -mk + inKappa[0];
        return result;
    }

    public static boolean fastDtoa(double v, int requestedDigits, DecimalRepBuf buf) {
        assert (v > 0.0);
        assert (!Doubles.isSpecial(v));
        int[] decimalExponent = new int[1];
        boolean result = FastDtoa.grisu3Counted(v, requestedDigits, buf, decimalExponent);
        if (result) {
            buf.setPointPosition(buf.length() + decimalExponent[0]);
        } else {
            buf.reset();
        }
        return result;
    }
}

